/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
//  Includes
//---------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>
#include <OSGSysFieldDataType.h>

#include "OSGStatUInt64Elem.h"

OSG_USING_NAMESPACE


/***************************************************************************\
 *                            Description                                  *
\***************************************************************************/

/*! \class osg::StatUInt64Elem
    \ingroup GrpSystemStatistics

    The StatUInt64Elem keeps an UInt64 counter, see \ref PageSystemStatistics for
    details. 
*/

/***************************************************************************\
 *                         Instance methods                                *
\***************************************************************************/

/*------------- constructors & destructors --------------------------------*/

StatUInt64Elem::StatUInt64Elem(StatElemDescBase *desc)
  : StatElem(desc), _value(0)
{
}

StatElem *StatUInt64Elem::create ( StatElemDescBase *desc)
{
  return new StatUInt64Elem(desc);
}

StatUInt64Elem::~StatUInt64Elem(void)
{
}

/*------------------------------ access -----------------------------------*/

void StatUInt64Elem::putToString(std::string &str, const char *format) const
{
    if(!format)
    {
        FieldDataTraits<UInt64>::putToString(_value, str);
    }
    else
    {
        char *temp = new char [strlen(format) + 40];
        sprintf(temp, format, _value);
        str = temp;
        delete [] temp;

        ((StatElem*)this)->beautifyDigits(str);
    }
}

bool StatUInt64Elem::getFromString(const Char8 *&inVal)
{
    return FieldDataTraits<UInt64>::getFromString(_value, inVal);
}

Real64 StatUInt64Elem::getValue(void) const
{
    return static_cast<Real64>(get());
}


void StatUInt64Elem::reset(void) 
{ 
    _value = 0; 
}

/*-------------------------- assignment -----------------------------------*/

StatUInt64Elem& StatUInt64Elem::operator = (const StatUInt64Elem &source)
{
    if (this == &source)
        return *this;

    set(source.get());

    return *this;
}

/*-------------------------- comparison -----------------------------------*/

bool StatUInt64Elem::operator < (const StatUInt64Elem &other) const
{
    return this->get() < other.get();
}

/*--------------------------- creation ------------------------------------*/

StatElem *StatUInt64Elem::clone(void) const
{
    StatUInt64Elem *e = new StatUInt64Elem(getDesc());
    
    *e = *this;
    
    return e;
}

/*--------------------------- operators ------------------------------------*/

StatElem &StatUInt64Elem::operator += (const StatElem &other)
{
    const StatUInt64Elem *o = dynamic_cast<const StatUInt64Elem *>(&other);
    
    _value += o->_value;
    
    return *this;
}


/*-------------------------------------------------------------------------*/
/*                              cvs id's                                   */

#ifdef __sgi
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp[] = "@(#)$Id: $";
    static Char8 cvsid_hpp[] = OSGStatUInt64Elem_HEADER_CVSID;
    static Char8 cvsid_inl[] = OSGStatUInt64Elem_INLINE_CVSID;
}
