/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/


#ifndef _OSGSHADOWCAMERADECORATOR_H_
#define _OSGSHADOWCAMERADECORATOR_H_
#pragma once

#include <OSGConfig.h>

#include <OSGShadowCameraDecoratorBase.h>

OSG_BEGIN_NAMESPACE


/*! \brief Camera Decorator class to select a part of the image, see \ref
    PageSystemWindowCameraDecoratorsTile for a description.
*/

class OSG_SYSTEMLIB_DLLMAPPING ShadowCameraDecorator : public ShadowCameraDecoratorBase
{
    /*==========================  PRIVATE  ================================*/     
  private:

    typedef ShadowCameraDecoratorBase Inherited;

    /*==========================  PUPLIC   ================================*/       
  public:

    /*---------------------------------------------------------------------*/
    /*! \name                    Class Get                                 */
    /*! \{                                                                 */
    
    static const char *getClassname(void) { return "ShadowCameraDecorator"; };

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                     transformation                           */
    /*! \{                                                                 */
    
    virtual void changed(BitVector whichField, 
                         UInt32    origin    );

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                    access                                    */
    /*! \{                                                                 */

    virtual void getViewing(Matrix &result,
                            UInt32 width, UInt32 height, int eye = -1);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   dump                                       */
    /*! \{                                                                 */

    virtual void dump(      UInt32    uiIndent = 0, 
                      const BitVector bvFlags  = 0) const;

    /*! \}                                                                 */
    /*=========================  PROTECTED  ===============================*/
 protected:
    
    /*---------------------------------------------------------------------*/
    /*! \name                   Constructors                               */
    /*! \{                                                                 */

    ShadowCameraDecorator(void);
    ShadowCameraDecorator(const ShadowCameraDecorator &source);

    /*! \}                                                                 */
    /*---------------------------------------------------------------------*/
    /*! \name                   Destructors                                */
    /*! \{                                                                 */

    virtual ~ShadowCameraDecorator(void); 
    
    /*! \}                                                                 */
    /*=========================  PRIVATE    ===============================*/
 private:
    friend class FieldContainer;
    friend class ShadowCameraDecoratorBase;

    static void initMethod( void );

    void operator =(const ShadowCameraDecorator &source);
};

//---------------------------------------------------------------------------
//   Exported Types
//---------------------------------------------------------------------------

typedef ShadowCameraDecorator *ShadowCameraDecoratorP;

OSG_END_NAMESPACE

#include <OSGShadowCameraDecoratorBase.inl>
#include <OSGShadowCameraDecorator.inl>

#define OSGShadowCameraDecorator_HEADER_CVSID "@(#)$Id: $"

#endif /* _OSGShadowCameraDecorator_H_ */
