/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *               Copyright (C) 2000-2002 by the OpenSG Forum                 *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class CocoaWindow!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/


#define OSG_COMPILECOCOAWINDOWINST

#include <stdlib.h>
#include <stdio.h>

#include <OSGConfig.h>

#include "OSGCocoaWindowBase.h"
#include "OSGCocoaWindow.h"


OSG_BEGIN_NAMESPACE

const osg::BitVector  CocoaWindowBase::ContextFieldMask = 
    (TypeTraits<BitVector>::One << CocoaWindowBase::ContextFieldId);

const osg::BitVector CocoaWindowBase::MTInfluenceMask = 
    (Inherited::MTInfluenceMask) | 
    (static_cast<BitVector>(0x0) << Inherited::NextFieldId); 


// Field descriptions

/*! \var NSOpenGLContextP CocoaWindowBase::_sfContext
    
*/

//! CocoaWindow description

FieldDescription *CocoaWindowBase::_desc[] = 
{
    new FieldDescription(SFNSOpenGLContextP::getClassType(), 
                     "context", 
                     ContextFieldId, ContextFieldMask,
                     true,
                     reinterpret_cast<FieldAccessMethod>(&CocoaWindowBase::editSFContext))
};


FieldContainerType CocoaWindowBase::_type(
    "CocoaWindow",
    "Window",
    NULL,
    reinterpret_cast<PrototypeCreateF>(&CocoaWindowBase::createEmpty),
    CocoaWindow::initMethod,
    _desc,
    sizeof(_desc));

//OSG_FIELD_CONTAINER_DEF(CocoaWindowBase, CocoaWindowPtr)

/*------------------------------ get -----------------------------------*/

FieldContainerType &CocoaWindowBase::getType(void) 
{
    return _type; 
} 

const FieldContainerType &CocoaWindowBase::getType(void) const 
{
    return _type;
} 


FieldContainerPtr CocoaWindowBase::shallowCopy(void) const 
{ 
    CocoaWindowPtr returnValue; 

    newPtr(returnValue, dynamic_cast<const CocoaWindow *>(this)); 

    return returnValue; 
}

UInt32 CocoaWindowBase::getContainerSize(void) const 
{ 
    return sizeof(CocoaWindow); 
}


#if !defined(OSG_FIXED_MFIELDSYNC)
void CocoaWindowBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField)
{
    this->executeSyncImpl(static_cast<CocoaWindowBase *>(&other),
                          whichField);
}
#else
void CocoaWindowBase::executeSync(      FieldContainer &other,
                                    const BitVector      &whichField,                                    const SyncInfo       &sInfo     )
{
    this->executeSyncImpl((CocoaWindowBase *) &other, whichField, sInfo);
}
void CocoaWindowBase::execBeginEdit(const BitVector &whichField, 
                                            UInt32     uiAspect,
                                            UInt32     uiContainerSize) 
{
    this->execBeginEditImpl(whichField, uiAspect, uiContainerSize);
}

void CocoaWindowBase::onDestroyAspect(UInt32 uiId, UInt32 uiAspect)
{
    Inherited::onDestroyAspect(uiId, uiAspect);

}
#endif

/*------------------------- constructors ----------------------------------*/

#ifdef OSG_WIN32_ICL
#pragma warning (disable : 383)
#endif

CocoaWindowBase::CocoaWindowBase(void) :
    _sfContext                (NSOpenGLContextP(0)), 
    Inherited() 
{
}

#ifdef OSG_WIN32_ICL
#pragma warning (default : 383)
#endif

CocoaWindowBase::CocoaWindowBase(const CocoaWindowBase &source) :
    _sfContext                (source._sfContext                ), 
    Inherited                 (source)
{
}

/*-------------------------- destructors ----------------------------------*/

CocoaWindowBase::~CocoaWindowBase(void)
{
}

/*------------------------------ access -----------------------------------*/

SizeT CocoaWindowBase::getBinSize(const BitVector &whichField)
{
    SizeT returnValue = Inherited::getBinSize(whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
    {
        returnValue += _sfContext.getBinSize();
    }


    return returnValue;
}

void CocoaWindowBase::copyToBin(      BinaryDataHandler &pMem,
                                  const BitVector         &whichField)
{
    Inherited::copyToBin(pMem, whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
    {
        _sfContext.copyToBin(pMem);
    }


}

void CocoaWindowBase::copyFromBin(      BinaryDataHandler &pMem,
                                    const BitVector    &whichField)
{
    Inherited::copyFromBin(pMem, whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
    {
        _sfContext.copyFromBin(pMem);
    }


}

#if !defined(OSG_FIXED_MFIELDSYNC)
void CocoaWindowBase::executeSyncImpl(      CocoaWindowBase *pOther,
                                        const BitVector         &whichField)
{

    Inherited::executeSyncImpl(pOther, whichField);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
        _sfContext.syncWith(pOther->_sfContext);


}
#else
void CocoaWindowBase::executeSyncImpl(      CocoaWindowBase *pOther,
                                        const BitVector         &whichField,
                                        const SyncInfo          &sInfo      )
{

    Inherited::executeSyncImpl(pOther, whichField, sInfo);

    if(FieldBits::NoField != (ContextFieldMask & whichField))
        _sfContext.syncWith(pOther->_sfContext);



}

void CocoaWindowBase::execBeginEditImpl (const BitVector &whichField, 
                                                 UInt32     uiAspect,
                                                 UInt32     uiContainerSize)
{
    Inherited::execBeginEditImpl(whichField, uiAspect, uiContainerSize);

}
#endif



OSG_END_NAMESPACE

#include <OSGSFieldTypeDef.inl>
#include <OSGMFieldTypeDef.inl>

OSG_BEGIN_NAMESPACE

#if !defined(OSG_DO_DOC) || defined(OSG_DOC_DEV)
DataType FieldDataTraits<CocoaWindowPtr>::_type("CocoaWindowPtr", "WindowPtr");
#endif

OSG_DLLEXPORT_SFIELD_DEF1(CocoaWindowPtr, OSG_WINDOWCOCOALIB_DLLTMPLMAPPING);
OSG_DLLEXPORT_MFIELD_DEF1(CocoaWindowPtr, OSG_WINDOWCOCOALIB_DLLTMPLMAPPING);


/*------------------------------------------------------------------------*/
/*                              cvs id's                                  */

#ifdef OSG_SGI_CC
#pragma set woff 1174
#endif

#ifdef OSG_LINUX_ICC
#pragma warning( disable : 177 )
#endif

namespace
{
    static Char8 cvsid_cpp       [] = "@(#)$Id: OSGCocoaWindowBase.mm,v 1.2 2008/06/10 16:43:56 pdaehne Exp $";
    static Char8 cvsid_hpp       [] = OSGCOCOAWINDOWBASE_HEADER_CVSID;
    static Char8 cvsid_inl       [] = OSGCOCOAWINDOWBASE_INLINE_CVSID;

    static Char8 cvsid_fields_hpp[] = OSGCOCOAWINDOWFIELDS_HEADER_CVSID;
}

OSG_END_NAMESPACE

