/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *                     Copyright 2000-2002 by OpenSG Forum                   *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class QTWindow!
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#include <OSGConfig.h>

OSG_BEGIN_NAMESPACE


//! access the type of the class
inline osg::FieldContainerType &QTWindowBase::getClassType(void)
{
    return _type; 
} 

//! access the numerical type of the class
inline osg::UInt32 QTWindowBase::getClassTypeId(void) 
{
    return _type.getId(); 
} 

//! create a new instance of the class
inline QTWindowPtr QTWindowBase::create(void) 
{
    QTWindowPtr fc; 

    if(getClassType().getPrototype() != osg::NullFC) 
    {
        fc = QTWindowPtr::dcast(
            getClassType().getPrototype()-> shallowCopy()); 
    }
    
    return fc; 
}

//! create an empty new instance of the class, do not copy the prototype
inline QTWindowPtr QTWindowBase::createEmpty(void) 
{ 
    QTWindowPtr returnValue; 
    
    newPtr(returnValue); 

    return returnValue; 
}


/*------------------------------ get -----------------------------------*/

OSG_WINDOWQTLIB_DLLMAPPING
SFOSGQGLWidgetP *QTWindowBase::getSFGlWidget(void)
{
    return &_sfGlWidget;
}


OSG_WINDOWQTLIB_DLLMAPPING
OSGQGLWidgetP &QTWindowBase::getGlWidget(void)
{
    return _sfGlWidget.getValue();
}

OSG_WINDOWQTLIB_DLLMAPPING
const OSGQGLWidgetP &QTWindowBase::getGlWidget(void) const
{
    return _sfGlWidget.getValue();
}

OSG_WINDOWQTLIB_DLLMAPPING
void QTWindowBase::setGlWidget(const OSGQGLWidgetP &value)
{
    _sfGlWidget.setValue(value);
}



OSG_END_NAMESPACE

#define OSGQTWINDOWBASE_INLINE_CVSID "@(#)$Id: OSGQT4WindowBase.inl,v 1.1 2006/03/10 18:30:35 a-m-z Exp $"

