/* This is a template file for fcdEdit.
 * To create it from sample source,  cut'n'paste the source and apply the following
 * substitutions:
 * s|\|\\|g 
 * s|"|\"|g 
 * s|^|"| 
 * s|$|",|
 */

const char *FCBaseTemplate_inl[]={
"/*---------------------------------------------------------------------------*\\",
" *                                OpenSG                                     *",
" *                                                                           *",
" *                                                                           *",
" *               Copyright (C) 2000-2002 by the OpenSG Forum                 *",
" *                                                                           *",
" *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *",
" *                                                                           *",
"\\*---------------------------------------------------------------------------*/",
"/*---------------------------------------------------------------------------*\\",
" *                                License                                    *",
" *                                                                           *",
" * This library is free software; you can redistribute it and/or modify it   *",
" * under the terms of the GNU Library General Public License as published    *",
" * by the Free Software Foundation, version 2.                               *",
" *                                                                           *",
" * This library is distributed in the hope that it will be useful, but       *",
" * WITHOUT ANY WARRANTY; without even the implied warranty of                *",
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *",
" * Library General Public License for more details.                          *",
" *                                                                           *",
" * You should have received a copy of the GNU Library General Public         *",
" * License along with this library; if not, write to the Free Software       *",
" * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *",
" *                                                                           *",
"\\*---------------------------------------------------------------------------*/",
"/*---------------------------------------------------------------------------*\\",
" *                                Changes                                    *",
" *                                                                           *",
" *                                                                           *",
" *                                                                           *",
" *                                                                           *",
" *                                                                           *",
" *                                                                           *",
"\\*---------------------------------------------------------------------------*/",
"",
"/*****************************************************************************\\",
" *****************************************************************************",
" **                                                                         **",
" **                  This file is automatically generated.                  **",
" **                                                                         **",
" **          Any changes made to this file WILL be lost when it is          **",
" **           regenerated, which can become necessary at any time.          **",
" **                                                                         **",
" **     Do not change this file, changes should be done in the derived      **",
" **     class @!Classname!@!",
" **                                                                         **",
" *****************************************************************************",
"\\*****************************************************************************/",
"",
"#include <@!HeaderPrefix!@OSGConfig.h>",
"",
"OSG_BEGIN_NAMESPACE",
"",
"",
"//! access the type of the class",
"inline",
"osg::FieldContainerType &@!Classname!@Base::getClassType(void)",
"{",
"    return _type; ",
"} ",
"",
"//! access the numerical type of the class",
"inline",
"osg::UInt32 @!Classname!@Base::getClassTypeId(void) ",
"{",
"    return _type.getId(); ",
"} ",
"",
"@@if !Abstract",
"//! create a new instance of the class",
"inline",
"@!Classname!@Ptr @!Classname!@Base::create(void) ",
"{",
"    @!Classname!@Ptr fc; ",
"",
"    if(getClassType().getPrototype() != osg::NullFC) ",
"    {",
//"        fc = osg::dcast<@!Classname!@Ptr>(",
//"            getClassType().getPrototype()-> shallowCopy()); ",
"        fc = @!Classname!@Ptr::dcast(",
"            getClassType().getPrototype()-> shallowCopy()); ",
"    }",
"    ",
"    return fc; ",
"}",
"",
"//! create an empty new instance of the class, do not copy the prototype",
"inline",
"@!Classname!@Ptr @!Classname!@Base::createEmpty(void) ",
"{ ",
"    @!Classname!@Ptr returnValue; ",
"    ",
"    newPtr(returnValue); ",
"",
"    return returnValue; ",
"}",
"",
"@@endif",
"",
"@@if !Decorator",
"@@if !isDecoratable",
"/*------------------------------ get -----------------------------------*/",
"", 
"@@BeginFieldLoop@@",
"//! Get the @!Classname!@::_@!fieldname!@ field.",
"inline",
"const @!CARDINALITY!@@!CapsFieldtypeClean!@ *@!Classname!@Base::get"
"@!CARDINALITY!@@!Fieldname!@(void) const",
"{",
"    return &_@!fieldname!@;",
"}",
"",
"//! Get the @!Classname!@::_@!fieldname!@ field.",
"inline",
"@!CARDINALITY!@@!CapsFieldtypeClean!@ *@!Classname!@Base::edit"
"@!CARDINALITY!@@!Fieldname!@(void)",
"{",
"    return &_@!fieldname!@;",
"}",
"",
"#ifndef OSG_2_PREP",
"//! Get the @!Classname!@::_@!fieldname!@ field.",
"inline",
"@!CARDINALITY!@@!CapsFieldtypeClean!@ *@!Classname!@Base::get"
"@!CARDINALITY!@@!Fieldname!@(void)",
"{",
"    return &_@!fieldname!@;",
"}",
"#endif",
"",
"@@EndFieldLoop@@",


"",
"@@BeginSFFieldLoop@@",
"//! Get the value of the @!Classname!@::_@!fieldname!@ field.",
"inline",
"@!Fieldtype!@ &@!Classname!@Base::edit@!Fieldname!@(void)",
"{",
"    return _@!fieldname!@.getValue();",
"}",
"",
"//! Get the value of the @!Classname!@::_@!fieldname!@ field.",
"inline",
"const @!Fieldtype!@ &@!Classname!@Base::get@!Fieldname!@(void) const",
"{",
"    return _@!fieldname!@.getValue();",
"}",
"",
"#ifndef OSG_2_PREP",
"//! Get the value of the @!Classname!@::_@!fieldname!@ field.",
"inline",
"@!Fieldtype!@ &@!Classname!@Base::get@!Fieldname!@(void)",
"{",
"    return _@!fieldname!@.getValue();",
"}",
"#endif",
"",
"//! Set the value of the @!Classname!@::_@!fieldname!@ field.",
"inline",
"void @!Classname!@Base::set@!Fieldname!@(const @!Fieldtype!@ &value)",
"{",
"    _@!fieldname!@.setValue(value);",
"}",
"",
"@@EndSFFieldLoop@@",


"",
"@@BeginMFFieldLoop@@",
"//! Get the value of the \\a index element the @!Classname!@::_@!fieldname!@ field.",
"inline",
"@!Fieldtype!@ &@!Classname!@Base::edit@!Fieldname!@(const UInt32 index)",
"{",
"    return _@!fieldname!@[index];",
"}",
"",
"//! Get the value of the \\a index element the @!Classname!@::_@!fieldname!@ field.",
"inline",
"const @!Fieldtype!@ &@!Classname!@Base::get@!Fieldname!@(const UInt32 index) const",
"{",
"    return _@!fieldname!@[index];",
"}",
"",

"#ifndef OSG_2_PREP",
"//! Get the value of the \\a index element the @!Classname!@::_@!fieldname!@ field.",
"inline",
"@!Fieldtype!@ &@!Classname!@Base::get@!Fieldname!@(const UInt32 index)",
"{",
"    return _@!fieldname!@[index];",
"}",
"",
"//! Get the @!Classname!@::_@!fieldname!@ field.",
"inline",
"@!CARDINALITY!@@!CapsFieldtypeClean!@ &@!Classname!@Base::get@!Fieldname!@(void)",
"{",
"    return _@!fieldname!@;",
"}",
"",
"//! Get the @!Classname!@::_@!fieldname!@ field.",
"inline",
"const @!CARDINALITY!@@!CapsFieldtypeClean!@ &@!Classname!@Base::get@!Fieldname!@(void) const",
"{",
"    return _@!fieldname!@;",
"}",
"",
"#endif",
"",
"@@EndMFFieldLoop@@",
"@@endif",
"@@else",
"/*------------------------- decorator get ------------------------------*/",
"", 
"@@if Decorator",
"inline",
"const SF@!Parent!@Ptr *@!Classname!@Base::getSFDecoratee(void) const",
"{",
"    return &_sfDecoratee;",
"}",
"",
"inline",
"SF@!Parent!@Ptr *@!Classname!@Base::editSFDecoratee(void)",
"{",
"    return &_sfDecoratee;",
"}",
"",
"#ifndef OSG_2_PREP",
"inline",
"SF@!Parent!@Ptr *@!Classname!@Base::getSFDecoratee(void)",
"{",
"    return &_sfDecoratee;",
"}",
"#endif",
"",
"inline",
"const @!Parent!@Ptr &@!Classname!@Base::getDecoratee(void) const",
"{",
"    return _sfDecoratee.getValue();",
"}",
"",
"#ifndef OSG_2_PREP",
"inline",
"@!Parent!@Ptr &@!Classname!@Base::getDecoratee(void)",
"{",
"    return _sfDecoratee.getValue();",
"}",
"#endif",
"",
"inline",
"void @!Classname!@Base::setDecoratee(const @!Parent!@Ptr &value)",
"{",
"    _sfDecoratee.setValue(value);",
"}",
"@@endif",
"",
"@@BeginFieldLoop@@",
"inline",
"const @!CARDINALITY!@@!CapsFieldtypeClean!@ *@!Classname!@Base::get"
"@!CARDINALITY!@@!Fieldname!@(void) const",
"{",
"    if (getDecoratee() == NullFC)",
"        return nullptr;",
"",
"    return getDecoratee()->get@!CARDINALITY!@@!Fieldname!@();",
"}",
"",
"inline",
"@!CARDINALITY!@@!CapsFieldtypeClean!@ *@!Classname!@Base::edit"
"@!CARDINALITY!@@!Fieldname!@(void)",
"{",
"    if (getDecoratee() == NullFC)",
"        return nullptr;",
"",
"    return getDecoratee()->edit@!CARDINALITY!@@!Fieldname!@();",
"}",
"",
"#ifndef OSG_2_PREP",
"inline",
"@!CARDINALITY!@@!CapsFieldtypeClean!@ *@!Classname!@Base::get"
"@!CARDINALITY!@@!Fieldname!@(void)",
"{",
"    if (getDecoratee() == NullFC)",
"        return nullptr;",
"",
"    return getDecoratee()->get@!CARDINALITY!@@!Fieldname!@();",
"}",
"#endif",
"",
"@@EndFieldLoop@@",
"",
"@@BeginSFFieldLoop@@",
"inline",
"@!Fieldtype!@ &@!Classname!@Base::edit@!Fieldname!@(void)",
"{",
"    if ( getDecoratee() == osg::NullFC ) ",
"    {",
"        static @!Fieldtype!@ defaultValue = @!FieldTypedDefault!@;",
"        return defaultValue;",
"    }",
"",
"    return getDecoratee()->edit@!Fieldname!@();",
"}",
"",
"inline",
"const @!Fieldtype!@ &@!Classname!@Base::get@!Fieldname!@(void) const",
"{",
"    if ( getDecoratee() == osg::NullFC ) ",
"    {",
"        static @!Fieldtype!@ defaultValue = @!FieldTypedDefault!@;",
"        return defaultValue;",
"    }",
"",
"    return getDecoratee()->get@!Fieldname!@();",
"}",
"",
"#ifndef OSG_2_PREP",
"inline",
"@!Fieldtype!@ &@!Classname!@Base::get@!Fieldname!@(void)",
"{",
"    if ( getDecoratee() == osg::NullFC ) ",
"    {",
"        static @!Fieldtype!@ defaultValue = @!FieldTypedDefault!@;",
"        return defaultValue;",
"    }",
"",
"    return getDecoratee()->get@!Fieldname!@();",
"}",
"#endif",
"",
"inline",
"void @!Classname!@Base::set@!Fieldname!@(const @!Fieldtype!@ &value)",
"{",
"    if ( getDecoratee() == osg::NullFC ) ",
"        return;",
"",
"    beginEditCP(getDecoratee(), @!Fieldname!@FieldMask);",
"    getDecoratee()->set@!Fieldname!@(value);",
"    endEditCP(getDecoratee(), @!Fieldname!@FieldMask);",
"}",
"",
"@@EndSFFieldLoop@@",
"",
"@@BeginMFFieldLoop@@",
"inline",
"@!Fieldtype!@ &@!Classname!@Base::edit@!Fieldname!@(UInt32 index)",
"{",
"    return getDecoratee()->get@!Fieldname!@(index);",
"}",
"",
"inline",
"const @!Fieldtype!@ &@!Classname!@Base::get@!Fieldname!@(UInt32 index) const",
"{",
"    return getDecoratee()->get@!Fieldname!@(index);",
"}",
"",
"#ifndef OSG_2_PREP",
"inline",
"@!Fieldtype!@ &@!Classname!@Base::get@!Fieldname!@(UInt32 index)",
"{",
"    return getDecoratee()->get@!Fieldname!@(index);",
"}",
"",
"inline",
"@!CARDINALITY!@@!CapsFieldtypeClean!@ &@!Classname!@Base::get@!Fieldname!@(void)",
"{",
"    if ( getDecoratee() == osg::NullFC ) ",
"    {",
"        static @!CARDINALITY!@@!CapsFieldtypeClean!@ emptyMultifield;",
"        return emptyMultifield;",
"    }",
"",
"    return getDecoratee()->get@!Fieldname!@();",
"}",
"#endif",
"@@EndMFFieldLoop@@",
"@@endif",
"OSG_END_NAMESPACE",
"",
"#define OSG@!CLASSNAME!@BASE_INLINE_CVSID \"@(#)$Id: FCBaseTemplate_inl.h,v 1.22 2008/06/09 12:26:59 vossg Exp $\"",
"",
NULL};
