/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

/*****************************************************************************\
 *****************************************************************************
 **                                                                         **
 **                  This file is automatically generated.                  **
 **                                                                         **
 **          Any changes made to this file WILL be lost when it is          **
 **           regenerated, which can become necessary at any time.          **
 **                                                                         **
 **     Do not change this file, changes should be done in the derived      **
 **     class @!Classname!@
 **                                                                         **
 *****************************************************************************
\*****************************************************************************/

#ifndef _OSG@!CLASSNAME!@BASE_H_
#define _OSG@!CLASSNAME!@BASE_H_
#ifdef __sgi
#pragma once
#endif

#include <@!HeaderPrefix!@OSGConfig.h>

@@if Library
@@if UseLocalIncludes
#include "OSG@!Libname!@Def.h"
@@else
#include <OSG@!Libname!@Def.h>
@@endif
@@endif

@@if UseLocalIncludes
#include "OSGNewActionTypes.h"
#include "@!ParentHeaderPrefix!@@!ParentHeader!@"               // Parent
#include "@!HeaderPrefix!@OSG@!EnterStore!@FunctorStore.h"      // EnterStore
#include "@!HeaderPrefix!@OSG@!LeaveStore!@FunctorStore.h"      // LeaveStore
@@else
#include <OSGNewActionTypes.h>
#include <@!ParentHeaderPrefix!@@!ParentHeader!@>               // Parent
#include <@!HeaderPrefix!@OSG@!EnterStore!@FunctorStore.h>      // EnterStore
#include <@!HeaderPrefix!@OSG@!LeaveStore!@FunctorStore.h>      // LeaveStore
@@endif

@@BeginStateLoop@@
@@if StateElem_HAS_Header
@@if UseLocalIncludes
#include "@!HeaderPrefix!@@!StateElemHeader!@"   // @!StateElemName!@ type
@@else
#include <@!HeaderPrefix!@@!StateElemHeader!@>   // @!StateElemName!@ type
@@endif
@@endif
@@EndStateLoop@@

OSG_BEGIN_NAMESPACE

@@if Library
class OSG_@!LIBNAME!@LIB_DLLMAPPING @!Classname!@Base : public @!ParentName!@
@@else
class @!Classname!@Base : public @!ParentName!@
@@endif
{
    /*====  PUBLIC  =========================================================*/
  public:
    /*---------------------------------------- ------------------------------*/
    /*! \name    Types                                                       */
    /*! \{                                                                   */

    typedef @!ParentName!@::ResultE ResultE;
    typedef @!ParentName!@::Functor Functor;

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Destructor                                                  */
    /*! \{                                                                   */

    virtual ~@!Classname!@Base(void);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Start/Stop                                                  */
    /*! \{                                                                   */

    virtual ResultE start(void);
    virtual ResultE stop (void);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Enter/Leave                                                 */
    /*! \{                                                                   */

@@if !EnterStore_IS_Empty
    virtual ResultE enterNode(FunctorArgumentType &funcArg);
@@endif
@@if !LeaveStore_IS_Empty
    virtual ResultE leaveNode(FunctorArgumentType &funcArg);
@@endif

@@if EnterStore_IS_Simple
    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Enter Registration                                          */
    /*! \{                                                                   */

    static void regClassEnter  (const Functor &refFunc);
           void regEnter       (const Functor &refFunc);

    static void unregClassEnter(      void            );
           void unregEnter     (      void            );
@@endif
@@if EnterStore_IS_Single
    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Enter Registration                                          */
    /*! \{                                                                   */

    static void regClassEnter         (const Functor            &refFunc,
                                       const FieldContainerType &refType );
           void regEnter              (const Functor            &refFunc,
                                       const FieldContainerType &refType );
    static void regDefaultClassEnter  (const Functor            &refFunc );
           void regDefaultEnter       (const Functor            &refFunc );

    static void unregClassEnter       (      void                        );
           void unregEnter            (      void                        );
    static void unregDefaultClassEnter(      void                        );
           void unregDefaultEnter     (      void                        );
@@endif
@@if EnterStore_IS_Multi
    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Enter Registration                                          */
    /*! \{                                                                   */

    static void regClassEnter         (const Functor            &refFunc,
                                       const FieldContainerType &refType );
           void regEnter              (const Functor            &refFunc,
                                       const FieldContainerType &refType );
    static void regDefaultClassEnter  (const Functor            &refFunc );
           void regDefaultEnter       (const Functor            &refFunc );

    static void unregClassEnter       (const FieldContainerType &refType );
           void unregEnter            (const FieldContainerType &refType );
    static void unregDefaultClassEnter(      void                        );
           void unregDefaultEnter     (      void                        );
@@endif
@@if LeaveStore_IS_Simple
    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Leave Registration                                          */
    /*! \{                                                                   */

    static void regClassLeave  (const Functor &refFunc);
           void regLeave       (const Functor &refFunc);

    static void unregClassLeave(      void            );
           void unregLeave     (      void            );
@@endif
@@if LeaveStore_IS_Single
    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Leave Registration                                          */
    /*! \{                                                                   */

    static void regClassLeave         (const Functor            &refFunc,
                                       const FieldContainerType &refType );
           void regLeave              (const Functor            &refFunc,
                                       const FieldContainerType &refType );
    static void regDefaultClassLeave  (const Functor            &refFunc );
           void regDefaultLeave       (const Functor            &refFunc );

    static void unregClassLeave       (      void                        );
           void unregLeave            (      void                        );
    static void unregDefaultClassLeave(      void                        );
           void unregDefaultLeave     (      void                        );
@@endif
@@if LeaveStore_IS_Multi
    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Leave Registration                                          */
    /*! \{                                                                   */

    static void regClassLeave         (const Functor            &refFunc,
                                       const FieldContainerType &refType );
           void regLeave              (const Functor            &refFunc,
                                       const FieldContainerType &refType );
    static void regDefaultClassLeave  (const Functor            &refFunc );
           void regDefaultLeave       (const Functor            &refFunc );

    static void unregClassLeave       (const FieldContainerType &refType );
           void unregLeave            (const FieldContainerType &refType );
    static void unregDefaultClassLeave(      void                        );
           void unregDefaultLeave     (      void                        );
@@endif

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Public State Access                                         */
    /*! \{                                                                   */

@@BeginStateLoop@@
@@if StateElem_IS_Public
    inline const @!StateElemType!@ &get@!StateElemName!@(void                             ) const;
    inline       @!StateElemType!@ &get@!StateElemName!@(void                             );
    inline       void               set@!StateElemName!@(const @!StateElemType!@ &stateVal);
@@endif
@@EndStateLoop@@

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    State Management                                            */
    /*! \{                                                                   */

#ifdef OSG_NEWACTION_STATESLOTINTERFACE
    virtual UInt32          createStateClone  (void                       );
    virtual void            destroyStateClone (UInt32          slotId     );
#else
    virtual ActorBaseState *createStateClone  (void                       );
    virtual void            destroyStateClone (ActorBaseState *pStateClone);
#endif

    virtual void            createInitialState(void                       );
    virtual void            deleteInitialState(void                       );

    /*! \}                                                                   */
    /*====  PROTECTED  ======================================================*/
  protected:
    /*-----------------------------------------------------------------------*/
    /*! \name    Types & Friends                                             */
    /*! \{                                                                   */

    class   @!Classname!@BaseState;
    friend  class osg::@!Classname!@Base::@!Classname!@BaseState;

    typedef @!Classname!@BaseState     StateType;
    typedef @!ParentName!@::StateType  ParentStateType;
    typedef @!EnterStore!@FunctorStore EnterStoreType;
    typedef @!LeaveStore!@FunctorStore LeaveStoreType;

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    State Class                                                 */
    /*! \{                                                                   */

@@if Library
    class OSG_@!LIBNAME!@LIB_DLLMAPPING @!Classname!@BaseState : public ParentStateType
@@else
    class @!Classname!@BaseState : public ParentStateType
@@endif
    {
      public:
        inline   @!Classname!@BaseState(void                                );
        inline   @!Classname!@BaseState(const @!Classname!@BaseState &source);

        virtual ~@!Classname!@BaseState(void                                );

@@BeginStateLoop@@
@@if StateElem_IS_Hierarchical
        inline const @!StateElemType!@ &get@!StateElemName!@(void) const;
        inline       @!StateElemType!@ &get@!StateElemName!@(void);
@@endif
@@EndStateLoop@@

      private:
@@BeginStateLoop@@
@@if StateElem_IS_Hierarchical
        @!StateElemType!@ _state@!StateElemName!@;
@@endif
@@EndStateLoop@@
    };

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Constructor                                                 */
    /*! \{                                                                   */

    @!Classname!@Base(void);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    Event Notification                                          */
    /*! \{                                                                   */

    virtual void addEvent(NewActionBase *pAction, UInt32 actorId);
    virtual void subEvent(NewActionBase *pAction, UInt32 actorId);

    /*! \}                                                                   */
    /*-----------------------------------------------------------------------*/
    /*! \name    State Access                                                */
    /*! \{                                                                   */

    inline const @!Classname!@BaseState *getCastState(void) const;
    inline       @!Classname!@BaseState *getCastState(void);

@@BeginStateLoop@@
@@if StateElem_IS_Protected
    inline const @!StateElemType!@ &get@!StateElemName!@(void) const;
    inline       @!StateElemType!@ &get@!StateElemName!@(void);
    inline       void               set@!StateElemName!@(const @!StateElemType!@ &stateVal);
@@endif
@@EndStateLoop@@

    /*! \}                                                                   */
    /*====  PRIVATE  ========================================================*/
  private:
    typedef @!ParentName!@ Inherited;

    static EnterStoreType *_pClassEnterStore;
    static LeaveStoreType *_pClassLeaveStore;

@@BeginStateLoop@@
@@if !StateElem_IS_Hierarchical
    @!StateElemType!@ _state@!StateElemName!@;
@@endif
@@EndStateLoop@@

    EnterStoreType         _instanceEnterStore;
    LeaveStoreType         _instanceLeaveStore;
};

OSG_END_NAMESPACE

@@if UseLocalIncludes
#include "OSG@!Classname!@Base.inl"
@@else
#include <OSG@!Classname!@Base.inl>
@@endif

#define OSG@!CLASSNAME!@BASE_HEADER_CVSID "@(#)$Id:"

#endif /* _OSG@!CLASSNAME!@BASE_H_ */
