/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _NODES_H_
#define _NODES_H_
#ifdef __sgi
#pragma once
#endif

#include <OSGConfig.h>
#include <OSGNode.h>
#include <OSGGroup.h>
#include <OSGTransform.h>
#include <OSGGeometry.h>
#include <OSGLight.h>

class NodeIterator;
class Geometry;
class Transform;

template<class type> class TypedNodeIterator;


class NodeBase
{
     /*==========================  PUBLIC  =================================*/
  public:
 
    NodeBase(void);
 
    NodeBase(const NodeBase &copy);
 
    NodeBase(osg::NodePtr node);
 
    NodeBase(osg::NodeCorePtr core);
    
    ~NodeBase();
    
    const char *getType(void);

    static const char * getCoreName(void) { return "<none>"; }
    
    void dump(void);
    
    inline osg::NodePtr getNode(void);

    NodeBase clone(void);
    
    NodeIterator iter(const char * name);
    
    TypedNodeIterator<Geometry>  geometries(void);
    TypedNodeIterator<Transform> transforms(void);
    
    /*=========================  PROTECTED  ===============================*/
  protected:

    osg::NodePtr _node;

    /*==========================  PRIVATE  ================================*/
  private:

};

class Group : public NodeBase
{
    /*==========================  PUBLIC  =================================*/
  public:
 
    Group(void);
  
    Group(const Group &copy);
  
    Group(osg::NodePtr node);
  
    Group(osg::GroupPtr group);
   
    ~Group();

    static const char * getCoreName(void) { return "Group"; }
    
    void addChild(NodeBase &node);
    
    void subChild(NodeBase &node);
         
    /*=========================  PROTECTED  ===============================*/
  protected:


    /*==========================  PRIVATE  ================================*/
  private:

    osg::GroupPtr _group;
};

class Transform : public Group
{
    /*==========================  PUBLIC  =================================*/
  public:
 
    Transform(void);
 
    Transform(const Transform &copy);
 
    Transform(osg::NodePtr node);
 
    Transform(osg::TransformPtr transform);
    
    ~Transform();

    static const char * getCoreName(void) { return "Transform"; }
    
    void setTranslation(osg::Real32 x, osg::Real32 y, osg::Real32 z);    
         
    /*=========================  PROTECTED  ===============================*/
  protected:


    /*==========================  PRIVATE  ================================*/
  private:

    osg::TransformPtr _transform;
};

class Light : public Group
{
    /*==========================  PUBLIC  =================================*/
  public:
 
    Light(void);
 
    Light(const Light &copy);
 
    Light(osg::NodePtr node);
 
    Light(osg::LightPtr light);
    
    ~Light();
 
    static const char * getCoreName(void) { return "Light"; }
        
    /*=========================  PROTECTED  ===============================*/
  protected:


    /*==========================  PRIVATE  ================================*/
  private:

    osg::LightPtr _transform;
};

class Geometry : public NodeBase
{
    /*==========================  PUBLIC  =================================*/
  public:
 
    Geometry(void);

    Geometry(const Geometry &node);

    Geometry(osg::NodePtr node);

    Geometry(osg::GeometryPtr node);
    
    ~Geometry();

    static const char * getCoreName(void) { return "Geometry"; }

    void translate(osg::Real32 x, osg::Real32 y, osg::Real32 z);

    void scale(osg::Real32 x, osg::Real32 y, osg::Real32 z);
    
    void merge(Geometry &geo);
    
    void setDlistCache(bool cache);
    
    /*=========================  PROTECTED  ===============================*/
  protected:


    /*==========================  PRIVATE  ================================*/
  private:

    osg::GeometryPtr _geometry;
};

class NodeIterator
{
  public:
  
    NodeIterator(void);
    NodeIterator(NodeBase &start, const char *name);
    NodeIterator(const NodeIterator &copy);
    
    ~NodeIterator();
    
    NodeIterator __iter__(void);
    
    NodeBase next(void);

  protected:
  
    osg::FieldContainerType *_type;
    
  private:
  
    std::vector<osg::NodePtr> _stack;
};

template <class type>
class TypedNodeIterator : public NodeIterator
{
  public:
    
    TypedNodeIterator(void);

    TypedNodeIterator(NodeBase &start);
    TypedNodeIterator(const TypedNodeIterator<type> &copy);
    
    ~TypedNodeIterator();
    
    TypedNodeIterator<type> __iter__(void);
    
    type next(void);
};

// Functions

Geometry makeBox(osg::Real32 x, osg::Real32 y, osg::Real32 z,
                 osg::UInt16 hor, osg::UInt16 vert, osg::UInt16 depth);

Geometry makeTorus(osg::Real32 inner, osg::Real32 outer,
                   osg::UInt16 sides, osg::UInt16 rings);

Geometry makeSphere(osg::UInt16 latres, osg::UInt16 longres, 
                    osg::Real32 radius);

Geometry makePlane(osg::Real32 x, osg::Real32 y,
                   osg::UInt16 hor, osg::UInt16 vert);

void addRef(NodeBase &node);

void subRef(NodeBase &node);

NodeBase makeShared(NodeBase &node);

NodeBase loadScene(char *filename);

#include "Nodes.inl"

#endif
