/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _TEST_H_
#define _TEST_H_
#ifdef __sgi
#pragma once
#endif

#include <vector>
#include <OSGConfig.h>
#include <OSGNode.h>
#include <OSGStatCollector.h>
#include "TestWindow.h"
#include "Nodes.h"
#include "Image.h"

class Test
{
    /*==========================  PUBLIC  =================================*/
  public:
 
    Test(void);
    
    ~Test();

    // Set up scene characteristics
    
    void setScene(NodeBase &scene);
    
    void setScene(osg::NodePtr scene);
    
    void setWindow(TestWindow &win);
    
    void setHeadlight(bool on);
     
    // set near and far, if any <= 0 use showAll() values
    void setNearFar(osg::Real32 n, osg::Real32 f);
   
    // Setup Test Frames
   
    // clear all the animation data
    void clear(void);
    
    // MinTime takes precedence, the path is repeated fully until the time is
    // reached
   
    void setNFrames(osg::UInt32 nframes);     
    void setMinTime(osg::Real32 minTime);
    
    void addFromAtUp(osg::Real32 fromx, osg::Real32 fromy, osg::Real32 fromz, 
                     osg::Real32 atx,   osg::Real32 aty,   osg::Real32 atz, 
                     osg::Real32 upx,   osg::Real32 upy,   osg::Real32 upz);
    
    void addFromAtUp(osg::Pnt3f from, osg::Pnt3f at, osg::Vec3f up);
    
    // Define Path from VRML-Style Positon/Quaternion Strings
    void addFromOri(osg::Char8 *from, osg::Char8 *ori);
    
    // Make a rotational path around the whole model
    void makeOrbit(osg::Real32 upx = 0, osg::Real32 upy = 1, osg::Real32 upz =
    0);
    
    // Make a pirouette inside the model
    void makePirouette(osg::Real32 upx,   osg::Real32 upy,   osg::Real32 upz);

    // add a FOV to animate
    void addFov(osg::Real32 fov);  
    
    // Run Test
    
    void setVerbose(bool on);
    
    void setStatistics(osg::UInt16 level);
    
    osg::UInt16 getStatistics(void);
    
    void run(void);
    
    Image snapshot(osg::UInt32 frame);
    
    // Get Results
    
    osg::Real32 getFPS(void);
    
    osg::Real32 getTime(void);
    
    osg::UInt32 getNRenderedFrames(void);
    
    osg::Real64 getStatValue(osg::Char8 *name, osg::UInt32 frame);
    
         
    /*=========================  PROTECTED  ===============================*/
  protected:

    // Expand the data to fit NFrames 
    void expandData(std::vector<osg::Matrix>& views, 
                    std::vector<osg::Real32> &fovs);

    void runLoop(std::vector<osg::Matrix> &views, 
                 std::vector<osg::Real32> &fovs);

    /*==========================  PRIVATE  ================================*/
  private:
    
    TestWindow *_win;

    osg::NodePtr _scene;
    
    osg::Real32 _near, _far;    
    std::vector<osg::Pnt3f> _froms;
    std::vector<osg::Quaternion> _oris;
    std::vector<osg::Real32> _fovs;
    
    osg::Real32 _minTime;    
    osg::UInt32 _nFrames;
    bool _headlight;
    osg::UInt16 _statsLevel;
    bool _verbose;
    
    // Results
    osg::Real32 _time;    
    osg::UInt32 _nRenderedFrames;

    std::vector<osg::StatCollector> _stats;
};

#endif
