/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

#ifndef _TESTWINDOW_H_
#define _TESTWINDOW_H_
#ifdef __sgi
#pragma once
#endif

#include <OSGConfig.h>
#include <OSGMatrix.h>
#include <OSGNode.h>
#include <OSGGLUTWindow.h>
#include <OSGSimpleSceneManager.h>
#include <OSGPerspectiveCamera.h>
#include <OSGImage.h>
#include <OSGGrabForeground.h>

#include <Nodes.h>

class TestWindow
{
    /*==========================  PUBLIC  =================================*/
  public:
 
    TestWindow(void);
   
    ~TestWindow();
    
    void setSize(osg::UInt16 width, osg::UInt16 height);
    void setFullscreen(void);
    
    void setViewport(osg::Real32 left,   osg::Real32 right, 
                     osg::Real32 bottom, osg::Real32 top   );
 
    inline osg::UInt16 getWidth (void);
    inline osg::UInt16 getHeight(void);
    
    inline osg::PerspectiveCameraPtr getCamera(void);
    
    inline osg::NodePtr getScene(void             );
    inline void         setScene(osg::NodePtr root);
    inline void         setScene(NodeBase    &root);
    
    void setCamera(osg::Matrix mat);
    void setCamera(osg::Real32 fromx, osg::Real32 fromy, osg::Real32 fromz, 
                   osg::Real32 atx,   osg::Real32 aty,   osg::Real32 atz, 
                   osg::Real32 upx,   osg::Real32 upy,   osg::Real32 upz);

    void setNearFar(osg::Real32 n, osg::Real32 f);
    void setFov(osg::Real32 fov);
    
    void showAll(void);
    
    void finish(void);
    void redraw(void);

    osg::ImagePtr snapshot(void);
    
    void open  (void);
    void close (void);    
    inline bool isOpen(void);
    
    inline osg::SimpleSceneManager *getSSM(void);
    
    /*=========================  PROTECTED  ===============================*/
  protected:

    void update(void);

    /*==========================  PRIVATE  ================================*/
  private:
  
    osg::Int16 _width, _height;
    osg::Real32 _left, _right, _bottom, _top;
    osg::NodePtr _scene;  
    osg::GLUTWindowPtr _window;
    osg::SimpleSceneManager *_ssm;
    osg::Real32 _near, _far, _fov;
    osg::TransformPtr _beacon;
    osg::GrabForegroundPtr _grabber;
    
    bool _open;
};

#include "TestWindow.inl"

#endif
