/*---------------------------------------------------------------------------*\
 *                                OpenSG                                     *
 *                                                                           *
 *                                                                           *
 *             Copyright (C) 2000-2002 by the OpenSG Forum                   *
 *                                                                           *
 *                            www.opensg.org                                 *
 *                                                                           *
 *   contact: dirk@opensg.org, gerrit.voss@vossg.org, jbehr@zgdv.de          *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                License                                    *
 *                                                                           *
 * This library is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU Library General Public License as published    *
 * by the Free Software Foundation, version 2.                               *
 *                                                                           *
 * This library is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of                *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU         *
 * Library General Public License for more details.                          *
 *                                                                           *
 * You should have received a copy of the GNU Library General Public         *
 * License along with this library; if not, write to the Free Software       *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
 *                                                                           *
\*---------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*\
 *                                Changes                                    *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
 *                                                                           *
\*---------------------------------------------------------------------------*/

osg::UInt16 TestWindow::getWidth(void)
{
    return _width;
}

osg::UInt16 TestWindow::getHeight(void)
{
    return _height;
}

osg::NodePtr TestWindow::getScene(void)
{
    return _scene;
}

osg::PerspectiveCameraPtr TestWindow::getCamera(void)
{
    return osg::PerspectiveCameraPtr::dcast(
        getSSM()->getWindow()->getPort()[0]->getCamera());
}

osg::SimpleSceneManager *TestWindow::getSSM(void)
{
    return _ssm;
}

void TestWindow::setScene(osg::NodePtr scene)
{
    _scene = scene;
}

void TestWindow::setScene(NodeBase &scene)
{
    _scene = scene.getNode();
}

bool TestWindow::isOpen(void)
{
    return _open;
}
